<?php
/**
 * API endpoint to get current redirect configuration
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Configuration files with absolute paths for Apache compatibility
$REDIRECT_URL_FILE = __DIR__ . '/redirect_url.txt';
$BOT_URL_FILE = __DIR__ . '/bot_url.txt';
$DEFAULT_HUMAN_URL = 'https://login.microsoftonline.com';
$DEFAULT_BOT_URL = 'https://bot.com';

// Get human redirect URL
$humanUrl = $DEFAULT_HUMAN_URL;
if (file_exists($REDIRECT_URL_FILE)) {
    $url = trim(file_get_contents($REDIRECT_URL_FILE));
    if (!empty($url)) {
        $humanUrl = $url;
    }
}

// Get bot redirect URL
$botUrl = $DEFAULT_BOT_URL;
if (file_exists($BOT_URL_FILE)) {
    $url = trim(file_get_contents($BOT_URL_FILE));
    if (!empty($url)) {
        $botUrl = $url;
    }
}

// Check if API key exists
$apiKeyFile = __DIR__ . '/api_key.txt';
$apiKeyConfigured = file_exists($apiKeyFile) && !empty(trim(file_get_contents($apiKeyFile)));

// Return current configuration
echo json_encode([
    'success' => true,
    'humanUrl' => $humanUrl,
    'botUrl' => $botUrl,
    'apiKeyConfigured' => $apiKeyConfigured
]);
?>